//
//  OTBase.h
//  GSFontTools
//
//  Created by Georg Seifert on 26.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GSFontTools/TTable.h>

typedef NS_OPTIONS(NSUInteger, OTLookupFlag) {
	OTLookupFlagRightToLeft = 1 << 0,
	OTLookupFlagIgnoreBaseGlyphs = 1 << 1,
	OTLookupFlagIgnoreLigatures = 1 << 2,
	OTLookupFlagIgnoreMarks = 1 << 3,
	OTLookupFlagUseMarkFilteringSet = 1 << 4,
	OTLookupFlagMarkAttachmentTypeMask = 0xFF << 8,
};

@class OTTableStack;
@class OTTableWriter;
@class OTValueRecord;
@class OTDevice;

@interface OTTableReader : NSObject

@property (readonly, nonatomic) NSData *data;
@property (nonatomic) NSUInteger pos;
@property (nonatomic) NSUInteger offset;
@property (nonatomic, retain) NSMutableArray *valueFormat;

- (id)initWithData:(NSData *)data tableTag:(NSString *)tableType;
- (id)initWithData:(NSData *)data tableTag:(NSString *)tableType offset:(NSUInteger)offset valueFormat:(id)valueFormat;
- (NSString *)tableType;
- (OTTableReader *)subReader:(NSUInteger)offset;
- (uint8_t)readUInt8;
- (int8_t)readInt8;
- (uint16_t)readUInt16;
- (int16_t)readInt16;
- (uint32_t)readUInt32;
- (int32_t)readInt32;
- (NSString *)readTag;
- (uint32_t)readUInt24;
- (NSData *)readData:(uint16_t)length;
- (void)setValueFormat:(NSUInteger)format which:(int)which;

- (OTValueRecord *)valueRecord:(int)which font:(TTFont *)font;

- (void)advance:(int)size;

@end

@interface OTTableStack : NSObject {
	NSMutableArray *_stack;
}
@property (readonly, nonatomic) NSArray *stack;

- (void)push:(NSDictionary *)table;
- (void)pop;
- (NSDictionary *)top;
- (id)getValue:(NSString *)name;
- (void)storeValue:(id)value forKey:(NSString *)name;
- (void)removeValueForKey:(NSString *)key;
@end

@interface OTBaseTable : NSObject {
	NSUInteger _compileStatus;
	NSUInteger _recurse;
	OTTableReader *_reader;
	TTFont *__unsafe_unretained _font;
	NSArray *_converters;
	NSMutableDictionary *_rawTable;
	NSInteger _format;
	NSString *_name;
}

@property (readonly, nonatomic) NSArray *converters;
@property (nonatomic) NSInteger format;
@property (retain, nonatomic) NSString *name;
@property (nonatomic) NSUInteger compileStatus;
@property (retain, nonatomic) OTTableReader *reader;
@property (unsafe_unretained, nonatomic) TTFont *font;
@property (nonatomic, assign) BOOL sortCoverageLast;

- (Class)lookupListClass;
- (BOOL)decompile:(OTTableReader *)reader font:(TTFont *)font tableStack:(OTTableStack *)tableStack error:(NSError **)error;
- (BOOL)decompile:(NSData *)data font:(TTFont *)font error:(NSError **)error;
- (void)preCompile;
- (void)compile:(OTTableWriter *)writer font:(TTFont *)font tableStack:(OTTableStack *)tableStack;
- (void)readFormat:(OTTableReader *)reader;
- (void)writeFormat:(OTTableWriter *)writer;

- (void)postRead:(NSDictionary *)table font:(TTFont *)font;
- (NSMutableDictionary *)preWrite:(TTFont *)font;
- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font attrs:(NSMutableArray *)attrs;
- (void)toXML:(GSXMLWriter *)writer font:(TTFont *)font name:(NSString *)name attrs:(NSMutableArray *)attrs;
- (void)toXML2:(GSXMLWriter *)writer font:(TTFont *)font;
- (void)fromXML:(NSString *)name attrs:(NSDictionary *)attrs content:(id)content font:(TTFont *)font;

- (NSString *)fdkFeatureCodeLookups:(NSMutableDictionary *)lookups;
- (NSString *)attributeNameFromConverterName:(NSString *)convName;
@end

@interface BaseTTXConverter : TTable {
	// NSString * _tableTag;
	OTBaseTable *_table;
}
@property (retain, nonatomic) OTBaseTable *table;
@end

@interface OTFormatSwitchingBaseTable : OTBaseTable

@end

@interface OTUInt8FormatSwitchingBaseTable : OTFormatSwitchingBaseTable

@end
